/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1;

import com.roguewave.chart.standard.v2_1.Chart;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;

class DefaultMouseListener
implements MouseListener,
Serializable {
    Chart chart_;

    public DefaultMouseListener(Chart chart) {
        this.chart_ = chart;
    }

    public void mouseClicked(MouseEvent event) {
        int modifiers = event.getModifiers();
        if (modifiers != 0 && modifiers != 16) {
            this.chart_.autoScale();
            this.chart_.repaint();
            return;
        }
        int x = event.getX();
        int y = event.getY();
        int width = this.chart_.getSize().width;
        int height = this.chart_.getSize().height;
        if (this.chart_.getViewMode() == 2) {
            double rotation = this.chart_.getRotation();
            double tilt = this.chart_.getTilt();
            double distance = this.chart_.getViewDistance();
            if (x < width / 4) {
                rotation -= (double)5;
            } else if (x > 3 * width / 4) {
                rotation += (double)5;
            }
            if (y < height / 4) {
                tilt -= (double)5;
            } else if (y > 3 * height / 4) {
                tilt += (double)5;
            }
            this.chart_.setView(rotation, tilt, distance);
            this.chart_.repaint();
        } else if (this.chart_.getViewMode() == 1) {
            double shearX = this.chart_.getShearX();
            double shearY = this.chart_.getShearY();
            if (x < width / 4) {
                shearX += 0.05;
            } else if (x > 3 * width / 4) {
                shearX -= 0.05;
            }
            if (y < height / 4) {
                shearY -= 0.05;
            } else if (y > 3 * height / 4) {
                shearY += 0.05;
            }
            this.chart_.setShear(shearX, shearY);
            this.chart_.autoScale();
            this.chart_.repaint();
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }
}

